{!! adsense_testimonials_728x90() !!}
<section
    class="site-section relative py-20 transition-all duration-700 md:translate-y-8 md:opacity-0 [&.lqd-is-in-view]:translate-y-0 [&.lqd-is-in-view]:opacity-100"
    id="testimonials"
    x-data="slideshow('testimonials', {{ count($testimonials) }})"
    x-init="$el.querySelector('.lqd-cutout').style.setProperty('--shape-w', $el.querySelector('.lqd-testimonials-nav-wrap').offsetWidth + 55 + 'px')"
>
    <div class="container relative">
        <svg
            class="pointer-events-none absolute -top-20 start-1/2 z-2 -translate-x-1/2"
            width="66"
            height="159"
            viewBox="0 0 66 159"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M14.8281 89.3612L15.2478 89.6823C15.3529 89.4236 15.3835 89.1408 15.3359 88.8657C15.2882 88.5907 15.1644 88.3343 14.9783 88.1256H15.4887C15.546 88.0428 15.6607 87.948 15.6435 87.8851C15.6048 87.6377 15.6156 87.3851 15.6753 87.1419C15.7349 86.8987 15.8422 86.6695 15.991 86.4678C16.2685 85.9952 16.7938 85.658 16.5937 84.9968C16.5799 84.95 16.5747 84.8659 16.6005 84.8482C17.5914 84.151 17.6689 82.8509 18.4763 82.0343C18.7418 81.7651 18.7705 82.1395 19.0239 82.2006C19.1151 81.0434 18.9626 79.8124 20.0314 78.7958L20.5326 78.7386C20.6835 78.6615 20.672 78.6072 20.5567 78.51C20.4816 78.4592 20.4188 78.3923 20.373 78.3141C20.3271 78.236 20.2994 78.1487 20.2918 78.0585C20.2842 77.9684 20.2969 77.8776 20.3291 77.793C20.3612 77.7083 20.412 77.6319 20.4776 77.5694C21.2804 76.7339 21.5947 75.6332 22.1039 74.6485C23.0432 72.8329 24.1763 71.1391 25.2005 69.3784C26.2326 67.6068 27.3221 65.8798 28.469 64.1843C29.9863 61.9492 31.4509 59.6833 33.0273 57.4825C34.0457 56.0584 35.0734 54.6178 36.0092 53.1234C36.9032 51.6998 38.0477 50.4374 39.0364 49.0658C40.1964 47.46 41.5285 45.9879 42.6112 44.3163C43.1514 43.4825 43.9875 42.8453 44.5873 42.0133C46.8237 38.9244 49.6336 36.3511 52.3127 33.664C52.5297 33.3695 52.8103 33.1275 53.1339 32.9557C53.4575 32.784 53.8157 32.687 54.182 32.6719C53.9635 33.4867 53.5544 34.2383 52.9882 34.8652C52.0959 35.7384 51.2168 36.6265 50.3326 37.5083C49.8501 37.9045 49.4138 38.3534 49.032 38.8467C48.7114 39.361 48.2292 39.7102 47.9011 40.2143C47.5731 40.7183 47.1305 41.1172 46.7755 41.6126C46.162 42.4698 45.3781 43.2128 44.6762 44.0129C43.7799 45.0341 43.1514 46.2296 42.2556 47.2457C41.3381 48.2846 40.5789 49.4579 39.7325 50.5568C39.459 50.9111 39.0524 51.1386 39.0782 51.7067C39.088 51.9278 38.7439 52.1958 38.5168 52.3924C37.7795 53.1368 37.1489 53.9791 36.6428 54.8955C36.0476 55.7915 35.4679 56.6973 34.8715 57.5923C33.1598 60.1593 31.4882 62.7567 29.7105 65.2764C28.5803 66.8765 27.7946 68.6789 26.6002 70.231C26.5721 70.9619 25.7177 71.1288 25.5456 71.8312C25.4298 72.412 25.1564 72.9501 24.7549 73.3868C24.3758 73.7007 24.0611 74.0847 23.8282 74.5177C23.6296 75.0079 23.4041 75.4866 23.1527 75.952C22.9059 76.4296 22.6109 76.881 22.2724 77.2991C21.9077 77.7214 21.8028 78.2746 21.4828 78.682C21.3005 78.9141 21.4421 79.3678 21.0436 79.3878C20.6703 79.4067 20.6129 79.5998 20.6605 79.8833C20.7511 80.4256 20.3882 80.8085 20.2092 81.2491C19.965 81.3405 19.6857 81.1514 19.4224 81.4005C19.9202 82.2983 19.0256 83.0361 19.0933 83.915C18.1529 84.0756 18.5457 85.0414 18.1185 85.5151C17.6792 86.0026 17.7503 86.7038 17.357 87.2296C16.7952 88.1288 16.3261 89.0824 15.9566 90.0756C15.5384 90.9968 15.0721 91.8956 14.5597 92.7683C14.3401 93.1312 14.3922 93.3078 14.7455 93.6027C13.6445 94.0559 14.238 95.7131 12.864 96.028C12.9609 96.1812 13.1663 96.3675 13.1307 96.4715C12.8883 97.454 12.5411 98.4079 12.0951 99.3169C11.6176 99.9962 11.3425 100.796 11.3014 101.625C11.2821 101.97 11.1493 102.3 10.9235 102.563C9.97393 103.938 9.83915 105.561 9.40735 107.088C9.06329 108.296 8.62916 109.469 8.23177 110.656C7.67519 112.1 7.22012 113.58 6.86985 115.087C6.69782 116.026 6.25801 116.915 6.02404 117.847C5.85832 118.51 5.48389 119.153 5.64674 119.872C5.76831 120.41 5.21375 120.743 5.26937 121.308C5.28944 121.515 4.88064 121.955 5.04005 122.251C5.24191 122.623 4.37309 122.791 4.94366 123.127C4.80491 123.818 4.5833 124.489 4.28364 125.127C3.68382 126.099 3.78423 127.204 3.48088 128.227C2.99747 129.871 3.17518 131.66 2.50942 133.284C2.82022 134.027 1.87868 134.751 2.48653 135.538C2.63103 135.725 2.21872 135.988 2.17055 136.322C1.9125 138.102 1.4635 139.865 1.59711 141.676C1.62578 142.072 1.05748 142.44 1.56498 142.826C1.04602 143.213 1.3081 143.769 1.26853 144.255C1.23068 144.719 1.42448 145.278 1.22779 145.64C0.736925 146.541 1.46811 147.344 1.27658 148.208C1.11659 148.93 1.47268 149.73 0.957729 150.421C0.920287 150.49 0.900679 150.567 0.900679 150.646C0.900679 150.724 0.920287 150.802 0.957729 150.871C1.47956 151.45 1.29489 152.153 1.23353 152.774C1.12572 153.86 1.6877 154.848 1.5948 155.923C1.58333 156.051 1.87406 156.208 2.11777 156.437C2.14243 155.404 2.43945 154.451 1.96006 153.486C1.87256 153.193 1.84795 152.886 1.88782 152.583C1.88266 150.765 1.92392 148.946 1.86773 147.129C1.8425 146.307 2.35115 145.609 2.2227 144.76C2.04097 143.999 2.05203 143.204 2.25483 142.448C2.55015 141.702 2.27892 140.916 2.62184 140.266C2.99343 139.561 2.65969 138.845 2.83345 138.168C3.20561 136.714 3.12989 135.189 3.49173 133.758C3.79163 132.572 3.92759 131.358 4.29001 130.195C4.37373 129.925 3.83694 129.775 4.28307 129.502C4.5503 129.339 4.36453 128.926 4.38059 128.626C4.39492 128.352 4.78198 128.283 4.70055 127.976C4.60651 127.634 4.97009 127.43 4.99245 127.169C5.05668 126.426 5.14556 125.696 5.27917 124.954C5.54238 123.508 5.96272 122.109 6.28556 120.683C6.96509 120.235 6.28097 119.425 6.8114 118.86C7.20306 118.444 7.1021 117.737 7.23686 117.173C7.68586 115.297 8.22721 113.436 8.84882 111.609C9.37691 110.36 9.78025 109.062 10.053 107.734C10.1955 107.126 10.4301 106.544 10.7486 106.008C11.4291 104.414 12.0098 102.78 12.4873 101.114C12.7591 100.33 13.1828 99.6317 13.4971 98.8791C14.0132 97.639 14.2701 96.3029 14.995 95.1285C15.4692 94.3599 15.4388 93.3118 16.2387 92.6861C15.8774 91.8129 16.8391 91.3853 16.9377 90.6287C17.0341 89.8858 17.6328 89.2783 17.8598 88.524C18.1022 87.8441 18.4111 87.1897 18.7819 86.5701C19.126 85.9324 19.5137 85.3208 19.8835 84.6968H20.6129C20.4828 84.3305 20.1931 84.0144 20.3342 83.6493C20.4489 83.399 20.6995 83.5024 20.8641 83.4041C20.9119 83.3203 20.9444 83.2288 20.9604 83.1338C20.9733 82.1006 21.3191 81.0989 21.9467 80.2764C22.9514 78.8752 23.5311 77.2762 24.3712 75.8046C25.3558 74.0788 26.4104 72.39 27.3532 70.6476C28.4685 68.5903 29.8763 66.7296 30.9974 64.6786C31.8259 63.2889 32.7255 61.9424 33.6925 60.6446C34.8629 58.9433 36.113 57.2928 37.2088 55.5458C38.1022 54.1228 39.1763 52.8387 40.1293 51.4632C41.0635 50.0548 42.0735 48.6979 43.1548 47.3983C44.1296 46.277 44.9325 45.0158 45.8333 43.8294C46.8237 42.5219 47.9057 41.2869 48.8863 39.9691C49.5484 39.0705 50.2727 38.2192 51.0539 37.4214C52.4092 36.0541 53.773 34.6949 55.1454 33.3439C55.3175 33.1725 55.4471 32.9062 55.8089 32.9668C56.2195 33.348 55.9936 33.7703 55.661 34.1458C56.3979 34.3452 56.4729 33.5743 56.9919 33.58C57.2637 33.6103 57.3463 33.908 57.5613 34.0446C57.0498 34.2195 57.6531 34.6195 57.4094 34.8093C57.1485 35.0121 57.3446 35.4487 56.9736 35.5676C57.0108 35.939 57.4512 35.6201 57.5912 36.0585C57.1123 36.6751 56.5888 37.3843 56.0262 38.0615C55.5931 38.4808 55.2155 38.9536 54.9029 39.4685C54.6735 39.9411 53.9642 40.1428 54.1058 40.864C54.1316 40.9955 53.8764 41.0052 53.7704 41.0766C52.928 41.7555 52.2891 42.6523 51.9238 43.6688C51.6591 44.2415 51.3238 44.7791 50.9255 45.269C50.2764 46.1456 49.5492 46.9691 48.9643 47.8978C48.8398 48.0527 48.6783 48.1741 48.4947 48.2509C48.0914 48.4493 47.7394 48.7374 47.4659 49.0932C47.1924 49.449 47.0048 49.8628 46.9177 50.3025C46.8128 50.7894 46.6126 50.9311 46.0369 51.4758C45.7703 51.7642 45.5306 52.0762 45.3207 52.4078C44.3957 53.6822 43.6227 55.0578 42.6829 56.3087C42.1129 57.0665 42.1759 58.1552 41.2974 58.7089C41.4695 59.4215 40.7946 59.6467 40.5096 60.1005C39.8128 61.2103 38.8695 62.1995 38.522 63.4802C38.3981 63.9374 37.6102 63.6562 37.8568 64.2756C37.1027 65.2946 36.6853 66.5124 35.9548 67.5331C35.6749 67.9251 35.149 68.2491 35.0756 68.7012C34.9351 69.5584 33.8714 69.9396 34.0314 70.9014C33.1655 71.2814 33.1517 72.1529 32.8203 72.8667C32.5645 73.4182 31.9682 73.7393 31.8672 74.4868C31.6784 75.1346 31.3751 75.7436 30.9715 76.2852C30.6384 76.875 30.1114 77.3551 29.9784 78.0569C29.1939 78.1952 29.1858 78.9615 28.9203 79.4666C28.6336 80.0113 28.1794 80.5193 28.1703 81.1759C28.1634 81.6902 27.2356 81.5823 27.5126 82.3023C27.6846 82.7469 27.1851 83.0841 27.0177 83.483C26.8565 83.8671 26.8227 84.3859 26.1816 84.4139C25.9998 84.4219 25.7968 84.7208 25.6655 84.9248C25.1385 85.7363 25.119 86.8678 24.0954 87.3656C24.162 87.9559 23.6103 88.3771 23.5713 88.8514C23.4457 90.3887 22.5087 91.5562 21.8619 92.8306C21.3831 93.7741 21.3458 94.9508 20.4351 95.6743C20.5882 96.4921 19.8176 96.9927 19.7235 97.7162C19.6134 98.5626 18.9132 99.1528 18.7808 99.978C18.6483 100.803 18.1242 101.475 17.8816 102.258C17.8409 102.39 17.6706 102.482 17.5077 102.644C17.9091 104.028 16.4279 105.074 16.651 106.701L17.4802 105.052C17.5582 106.493 16.7318 107.442 16.5053 108.561C16.1878 109.668 15.7955 110.752 15.331 111.805C14.8829 112.867 14.4915 113.952 14.1583 115.055C13.8911 116.193 13.3836 117.241 13.1261 118.38C12.8721 119.505 12.4615 120.596 12.1019 121.76L11.3995 121.817C10.7607 122.59 11.1081 123.641 10.654 124.471C10.588 124.591 10.7114 124.832 10.6345 124.925C9.93836 125.772 10.1442 126.896 9.70842 127.82C9.25827 128.773 9.47499 129.861 9.08906 130.837C8.64063 131.97 8.61657 133.216 8.20713 134.368C7.99496 134.965 8.31095 135.683 7.82983 136.239C8.01907 137.166 7.63717 138.031 7.48578 138.91C7.29964 139.686 7.20432 140.481 7.20186 141.279C6.44951 141.874 7.31255 142.903 6.59517 143.532C6.49138 143.622 6.56709 143.932 6.58257 144.139C6.68407 145.457 6.28611 146.711 6.09572 147.991C6.03838 148.363 6.42604 148.653 6.27121 149.052C5.65534 150.636 6.09519 152.292 5.94781 153.909C5.8904 154.558 6.05182 155.207 6.40652 155.753L6.63591 155.562C6.80643 155.594 6.96755 155.664 7.10736 155.766C7.24718 155.869 7.36213 156.001 7.44371 156.154C7.52529 156.306 7.57139 156.475 7.57867 156.648C7.58595 156.821 7.55424 156.993 7.48578 157.152C7.32178 157.728 6.68696 157.688 6.14276 157.623C5.86981 158.152 5.64842 158.775 4.85707 158.572C4.40922 158.458 4.0927 158.728 3.73316 158.898C3.34895 158.686 2.97564 158.317 2.58628 158.297C2.22988 158.259 1.89104 158.123 1.60754 157.904C1.32404 157.686 1.10699 157.393 0.980619 157.059C0.661161 156.407 0.430899 155.715 0.29595 155.002C-0.17255 153.022 0.0665582 151.03 0.02183 149.046C-0.0206045 147.072 0.02471 145.097 0.00635999 143.123C-0.000521286 142.416 0.445652 141.819 0.36021 141.066C0.283942 140.398 0.0734815 139.632 0.638319 139.017C0.429587 137.888 1.07754 136.856 0.974319 135.715C0.843575 134.268 1.27255 132.861 1.59081 131.46C1.61778 131.15 1.67536 130.844 1.7628 130.545C1.91532 130.221 1.95259 129.855 1.86836 129.507C1.75367 128.862 2.18032 128.364 2.26232 127.771C2.41355 127.194 2.49342 126.601 2.50025 126.004C2.76174 125.771 3.04158 125.942 3.15398 125.559C2.63329 124.99 2.87529 124.332 3.11786 123.596C3.59099 122.154 3.91755 120.668 4.09268 119.161C4.18068 118.686 4.32113 118.223 4.51134 117.779C5.00316 116.612 5.28724 115.368 5.35085 114.104L5.92086 113.685C5.95183 113.366 5.60432 113.414 5.74194 113.091C6.05711 112.537 6.23832 111.918 6.27121 111.282C6.26835 111.183 6.28406 111.084 6.31762 110.99C6.4174 110.699 7.20419 110.62 6.58831 110.108C7.14168 109.887 6.72308 109.262 7.10442 108.908C7.35788 108.674 7.3854 108.165 7.45134 107.834C7.53162 107.434 7.79543 107.126 7.83844 106.73C7.92274 105.955 8.72783 105.372 8.43365 104.551C8.5707 104.27 8.82642 104.384 8.98756 104.273C8.87574 103.758 9.303 102.349 9.80705 101.581L10.2382 101.786C10.2727 101.684 10.3529 101.57 10.326 101.506C10.127 101.066 9.73306 100.643 10.2795 100.179C10.424 99.1218 10.7824 98.1051 11.333 97.1904C11.6949 96.4007 11.9842 95.5799 12.1977 94.7382C12.4351 93.949 13.1536 93.3701 13.1491 92.4877C14.0029 91.6305 14.0029 90.3122 14.8281 89.3612ZM23.6264 85.8832C23.3471 85.5717 23.9956 85.6323 23.6688 85.3689C23.3586 85.1208 23.5438 84.7945 23.4503 84.5197C23.4033 84.3831 23.3075 84.3717 23.2341 84.4625C22.995 84.8163 23.362 85.2843 23.0431 85.594L22.5752 85.69C22.7433 86.2169 23.3528 86.3575 23.4789 86.8484C23.2714 87.6296 22.6573 87.4884 22.1085 87.5062C22.0511 87.5062 21.9938 87.6205 21.9364 87.6839C22.1658 87.9931 22.5569 87.6365 22.7283 87.8348C23.1917 88.5326 22.2971 88.3034 22.2467 88.8766C22.2753 88.7995 22.6194 88.7731 22.4434 88.9909C22.1962 89.1875 21.8171 88.8886 21.5992 89.2075C21.8389 90.0544 21.6199 90.7156 20.7437 91.7922L20.9644 92.0117C20.8497 92.29 20.4483 92.0523 20.3446 92.3472C20.2201 92.6552 20.5487 92.7644 20.625 92.9838C19.7511 94.4125 19.7511 94.4125 19.7075 95.2914L18.3885 96.3772C18.1592 96.8618 18.669 97.063 18.7189 97.3745C18.4728 97.5484 18.2685 97.7745 18.1208 98.0365C17.9731 98.2986 17.8855 98.5901 17.8645 98.89C17.8358 99.2829 17.7192 99.6645 17.5232 100.007C17.2147 100.864 16.8884 101.716 16.5966 102.578C16.57 102.625 16.5555 102.678 16.5543 102.732C16.5532 102.786 16.5653 102.839 16.5898 102.887C16.6142 102.935 16.6502 102.976 16.6945 103.007C16.7388 103.038 16.7901 103.057 16.8437 103.063C17.1371 102.623 17.3726 102.148 17.5444 101.648C17.869 100.493 18.2896 99.3664 18.802 98.2808C19.3433 97.2058 19.5096 95.9681 20.3142 95.0017C20.4864 94.7138 20.6134 94.4014 20.6909 94.0753C21.3195 92.3624 22.0646 90.6942 22.921 89.0823C23.3672 88.1943 24.0318 87.3616 24.0891 86.3004C24.0801 86.2039 24.0564 86.1093 24.0191 86.0198L23.6264 85.8832Z"
                fill="#030303"
            />
            <path
                d="M25.9751 43.5478C26.0359 44.1764 25.3208 44.7239 25.7911 45.3908C26.1988 45.5623 26.3025 45.1496 26.6105 45.0051C26.5936 44.1213 26.8542 43.2543 27.356 42.5254C27.8021 41.7168 28.4925 41.0813 28.8286 40.1824C29.2285 39.3456 29.7242 38.5576 30.3057 37.8342C30.8293 37.0598 31.3798 36.3038 31.9159 35.5374C32.3058 34.9121 32.7302 34.3088 33.1873 33.7304C34.3433 32.416 35.3353 30.9873 36.3985 29.6021C36.949 28.8849 37.6188 28.2654 38.1813 27.5385C39.147 26.2904 40.3604 25.2348 41.3392 23.9953C42.3921 22.6598 43.7047 21.5705 44.7638 20.2658C47.1516 17.325 50.0395 14.8837 52.6492 12.1629C53.0724 11.7212 53.5288 11.3057 53.9543 10.8583C54.8885 9.8736 55.7716 8.78377 57.1169 8.3323C57.6358 8.16086 57.3801 7.57054 57.9197 7.31966C58.4604 7.0403 58.9275 6.63795 59.2833 6.14525C59.6972 5.6881 60.1521 5.26957 60.6424 4.89486C61.1717 4.38796 61.7921 3.92791 62.3696 3.39244C62.9493 3.31586 63.5595 3.24729 64.1639 3.14214C64.2665 3.12442 64.341 2.94897 64.4173 2.85982C64.2969 2.56379 63.8129 2.91184 63.8301 2.29636C64.2751 1.66685 64.8941 1.17981 65.6118 0.894531C65.7683 0.955108 65.6468 1.21059 65.754 1.36032C65.8538 1.50033 66.098 1.57859 65.8389 1.80832C65.555 2.0592 65.984 2.0838 66.0023 2.26267C65.68 2.59755 65.2173 2.26266 64.8663 2.45639C64.4156 2.89186 65.2029 3.03189 65.0527 3.44964C64.6858 3.72418 64.2778 3.93955 63.8439 4.08795V4.66514C63.0984 5.44692 61.8495 5.62805 61.4704 6.77958C61.2904 7.32591 60.5139 7.18765 60.3448 7.85228C60.2301 8.31632 59.5775 8.41457 59.167 8.63401C58.8802 8.70088 58.8412 8.39917 58.6021 8.35288C58.25 8.94664 58.9611 9.06611 59.1262 9.42614L58.3555 10.1942L58.0264 9.89814C57.7397 10.261 57.1559 10.2119 56.9586 10.6525C56.8542 10.9708 57.0888 11.1222 57.2487 11.2971L56.79 11.7543L56.4586 11.4543C56.3674 12.0532 56.0501 12.5947 55.5715 12.9682C55.1901 12.9533 55.5715 12.3166 54.834 12.4212C54.428 12.6184 54.7497 13.7436 53.8379 13.7539L54.2302 14.3151C53.6568 14.7631 53.2244 15.3717 52.6871 15.7735C52.0798 16.2272 51.7827 16.9165 51.1198 17.3531H50.1685C50.1548 17.8823 49.5285 18.108 49.4592 18.5617C49.2258 20.0882 47.9952 20.8219 46.9934 21.7008C46.6276 22.0226 46.1619 22.2151 45.995 22.7215C45.9417 22.8826 45.8838 22.9832 45.6917 22.9832C44.8797 22.9832 44.5024 23.4233 44.4198 24.2016C44.4163 24.2909 44.395 24.3784 44.3573 24.4594C44.3195 24.5404 44.2661 24.6131 44.1999 24.6733C44.1338 24.7335 44.0563 24.7801 43.972 24.8102C43.8877 24.8404 43.7982 24.8536 43.7087 24.8491C43.0349 24.8685 42.8331 25.4114 42.5441 25.7212C42.5705 26.2789 43.0349 25.9498 43.1748 26.2972C42.7861 26.3704 42.7941 27.219 42.0933 26.7653C42.0503 26.7373 41.692 27.0013 41.6862 27.139C41.6833 27.3919 41.6196 27.6404 41.5004 27.8637C41.3813 28.087 41.2102 28.2787 41.0015 28.4226C41.1443 29.1798 40.5548 29.5369 40.1058 29.9135C39.5727 30.4508 39.1084 31.0515 38.7233 31.7023C38.2332 32.4444 37.5842 33.0689 36.8228 33.531C36.6254 33.6605 36.4395 33.8068 36.2672 33.9682C36.3136 34.2338 36.3003 34.5064 36.2282 34.7663C36.1561 35.0263 36.0271 35.267 35.8503 35.4711C34.6064 36.9346 33.5007 38.5094 32.5473 40.1755C32.4023 40.4331 32.1919 40.6483 31.9373 40.7996C31.6828 40.951 31.3929 41.0331 31.0965 41.0379C30.7146 41.0784 30.5942 41.3573 30.4124 41.4836C30.7725 42.4551 29.6411 43.1592 30.0987 43.9981C29.656 44.2987 29.2798 44.0827 28.891 44.2302C28.6616 45.0588 28.4116 45.9417 28.1668 46.8167C28.2878 47.0955 28.6943 46.8452 28.801 47.2795C28.7201 47.6481 28.2448 47.9956 28.5871 48.7603L28.0011 48.2413C27.7281 48.3556 28.0011 48.7786 27.6381 48.8431C27.1965 48.9071 27.0853 48.4613 26.8066 48.2773L25.568 48.906C25.1666 48.5442 25.3919 48.3242 25.6334 48.1059C25.4504 47.8859 25.3363 47.5767 24.9394 47.6098C24.5323 47.6133 24.8747 48.0876 24.5547 48.2133C23.8207 47.4007 24.8145 46.4726 24.268 45.6514L25.0943 45.0473L24.7714 44.6896C25.0054 44.2279 25.2526 43.7358 25.5089 43.2484C25.5198 43.2266 25.6081 43.2449 25.6603 43.2449C25.8786 43.2301 25.9835 43.331 25.9751 43.5478Z"
                fill="#030303"
            />
            <path
                d="M25.9751 43.5481C25.9831 43.3328 25.8787 43.229 25.662 43.2367C25.5742 42.1211 26.3169 41.3073 26.7957 40.4364C27.5928 38.9906 28.5733 37.6448 29.4696 36.2532C30.1302 35.2246 30.9881 34.2793 31.7273 33.277C32.7308 31.9152 33.896 30.6842 34.8519 29.2806C35.4765 28.4848 36.1483 27.7268 36.8636 27.0107C37.7275 25.8726 38.6688 24.7949 39.6809 23.7853C40.2907 23.3251 40.7939 22.7394 41.1563 22.068C41.246 21.884 41.3776 21.7234 41.5408 21.5992C41.7039 21.4749 41.8939 21.3905 42.0956 21.3525C42.3285 21.3045 42.3938 20.7908 42.645 20.5216C45.1377 17.8505 47.6482 15.1983 50.2528 12.6353C51.8636 11.0483 53.6097 9.61099 55.2521 8.05829C56.5634 6.81434 57.946 5.64711 59.3928 4.56253C59.9485 4.14764 60.3952 3.45104 61.1521 3.31445C61.4331 3.62134 61.3528 3.85849 61.1074 4.00822C59.5662 4.98951 58.169 6.17906 56.9557 7.54283C56.5377 7.9943 55.9235 8.14571 55.5158 8.62461C55.1995 9.08733 54.7545 9.44789 54.2353 9.66187C53.8444 9.82216 53.5332 10.1304 53.37 10.5191C53.1464 11.1077 52.6022 11.3323 52.273 11.762C51.9159 12.153 51.5203 12.5074 51.0923 12.8198C50.5258 13.325 50.2563 14.1513 49.4339 14.4199C49.3766 15.2023 48.4441 15.232 48.2199 15.7612C47.9544 16.387 47.3484 16.5613 46.9664 17.0184C46.6363 17.4869 46.2591 17.9206 45.8408 18.3128C45.3717 18.7244 44.9258 19.1615 44.5052 19.6221C44.0631 20.0627 43.6158 20.4976 43.1806 20.945C42.762 21.3754 42.4265 21.8943 42.0382 22.3241C41.185 23.2681 40.5015 24.3482 39.549 25.218C38.5631 26.2051 37.6653 27.2759 36.8659 28.4182C36.0549 29.5574 35.1638 30.6377 34.1994 31.6511C33.4539 32.3751 33.1781 33.4301 32.2795 33.985C32.2181 34.7554 31.4383 35.0445 31.1114 35.6766C30.8575 36.2509 30.4301 36.732 29.8888 37.0527C29.5838 37.2093 29.5832 38.0356 29.2976 38.1339C28.7506 38.3219 28.8962 38.6888 28.7431 39.01C28.6453 39.2839 28.5102 39.5431 28.3417 39.7804C27.4417 40.8715 26.7297 42.1039 26.2348 43.4275C26.2079 43.4972 26.064 43.5086 25.9751 43.5481Z"
                fill="#030303"
            />
        </svg>

        <div
            class="relative rounded-3xl bg-[#e1e7fd] bg-cover bg-left px-5 pb-44 pt-32 lg:px-20 xl:px-28"
            id="testimonials-content"
            style="background-image: url({{ custom_theme_url('assets/landing-page/testimonials-bg.jpg') }})"
        >
            <figure
                class="absolute -bottom-5 end-14 hidden motion-translate-y-loop-[-20px] motion-ease-out-quart motion-loop-infinite sm:block"
                aria-hidden="true"
            >
                <img
                    src="{{ custom_theme_url('/assets/landing-page/decor-8.png') }}"
                    width="141"
                    height="208"
                >
            </figure>

            <div class="flex flex-wrap items-center justify-between gap-y-8">
                <div class="w-full lg:w-5/12">
                    <div class="relative grid w-full place-items-center">
                        <svg
                            class="col-start-1 col-end-1 row-start-1 row-end-1 hidden lg:block"
                            width="393"
                            height="393"
                            viewBox="0 0 393 393"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                            preserveAspectRatio="none"
                        >
                            <mask id="testimonials-avatars">
                                <path
                                    fill="white"
                                    d="M30 393C13.4315 393 0 379.569 0 363V122.299C0 112.696 4.59747 103.673 12.3668 98.0282L139.409 5.72924C144.535 2.00556 150.707 0 157.042 0H363C379.569 0 393 13.4314 393 30V273.482C393 283.441 388.058 292.75 379.81 298.33L247.485 387.848C242.522 391.206 236.668 393 230.676 393H30Z"
                                />
                            </mask>
                        </svg>
                        @foreach ($testimonials as $item)
                            <figure
                                class="col-start-1 col-end-1 row-start-1 row-end-1 w-full max-w-full lg:[mask-image:url(#testimonials-avatars)] lg:[mask-size:cover]"
                                @if (!$loop->first) x-cloak @endif
                                x-show="activeSlide === {{ $loop->index }}"
                                x-transition
                            >
                                <img
                                    class="w-full max-w-full"
                                    src="{{ url('') . isset($item->avatar) ? (str_starts_with($item->avatar, 'asset') ? custom_theme_url($item->avatar) : '/testimonialAvatar/' . $item->avatar) : custom_theme_url('assets/img/auth/default-avatar.png') }}"
                                    alt="{{ $item->full_name }}"
                                >
                            </figure>
                        @endforeach
                    </div>
                </div>
                <div class="w-full lg:w-6/12">
                    <h2 class="mb-11 xl:text-[66px]/none [&_svg]:inline">
                        {!! __($fSectSettings->testimonials_title) !!}
                    </h2>

                    <div class="grid place-items-start">
                        @foreach ($testimonials as $item)
                            <div
                                class="col-start-1 col-end-1 row-start-1 row-end-1"
                                @if (!$loop->first) x-cloak @endif
                                x-show="activeSlide === {{ $loop->index }}"
                                x-transition
                            >
                                <h5 class="mb-5">
                                    {{ $item->full_name }},
                                    {{ $item->job_title }}
                                </h5>
                                <p class="text-[19px]/[150%] text-heading-foreground">
                                    {!! __($item->words) !!}
                                </p>
                            </div>
                        @endforeach
                    </div>
                    @if (filled($clients))
                        <div class="mt-12 flex flex-wrap items-center opacity-80 max-lg:gap-12 max-md:flex-wrap max-sm:gap-4 lg:gap-x-8 lg:gap-y-7">
                            @foreach ($clients as $entry)
                                <img
                                    src="{{ url('') . isset($entry->avatar) ? (str_starts_with($entry->avatar, 'asset') ? custom_theme_url($entry->avatar) : '/clientAvatar/' . $entry->avatar) : custom_theme_url('assets/img/auth/default-avatar.png') }}"
                                    alt="{{ __($entry->alt) }}"
                                    title="{{ __($entry->title) }}"
                                >
                                @if (!$loop->last)
                                    <span class="h-9 w-0.5 bg-heading-foreground/20"></span>
                                @endif
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            <x-shape-cutout
                width="216px"
                height="80px"
                x="7.5rem"
                roundness="40px"
                position="bl"
                el-id="testimonials-content"
            />
        </div>

        <div class="lqd-testimonials-nav-wrap absolute bottom-7 start-7 z-2 flex items-center gap-3 sm:bottom-5 lg:start-40">
            <button
                class="relative inline-grid size-10 place-items-center rounded-full bg-heading-foreground/5 text-heading-foreground transition-all hover:scale-110 hover:bg-heading-foreground hover:text-background"
                type="button"
                @click.prevent="$data.setActiveSlide('<')"
            >
                <x-tabler-chevron-left class="size-4" />
            </button>
            <div class="lqd-curtain-item-dots contents">
                @foreach ($testimonials as $slide)
                    <button
                        @class([
                            'inline-flex size-2.5 rounded-full bg-heading-foreground/5 transition-all hover:scale-110 hover:bg-heading-foreground/70 [&.active]:w-[18px] [&.active]:bg-heading-foreground',
                            'active' => $loop->first,
                        ])
                        type="button"
                        @click.prevent="$data.setActiveSlide({{ $loop->index }})"
                        :class="{ 'active': $data.activeSlide === {{ $loop->index }} }"
                    ></button>
                @endforeach
            </div>
            <button
                class="relative inline-grid size-10 place-items-center rounded-full bg-heading-foreground/5 text-heading-foreground transition-all hover:scale-110 hover:bg-heading-foreground hover:text-background"
                type="button"
                @click.prevent="$data.setActiveSlide('>')"
            >
                <x-tabler-chevron-right class="size-4" />
            </button>
        </div>
    </div>
</section>
